local res = external_profile("Config/Input/Aircrafts/common_joystick_binding.lua")
local cockpit = folder.."../../../Cockpit/"
dofile(cockpit.."devices.lua")
dofile(cockpit.."command_defs.lua")

join(res.keyCommands,{
	--HOTAS Stick
	{category = _('HOTAS'), name = _('Weapons FIRE/Bomb Release'),					down = iCommandPlaneFire,					up = iCommandPlaneFireOff,													},
	{category = _('HOTAS'), name = _('Autopilot Standby Mode'),						down = iCommandPlaneAutopilotOverrideOn,	up = iCommandPlaneAutopilotOverrideOff,										},
	{category = _('HOTAS'), name = _('Autopilot Disconnect/Exceed Elastic Limit'),	down = iCommandPlane_HOTAS_PinkySwitchAft,	up = iCommandPlane_HOTAS_PinkySwitchForward,								},
	{category = _('HOTAS'), name = _('Nosewheel Steering/IFF Interrogate'),			down = iCommandPlane_HOTAS_BoatSwitchAft,	up = iCommandPlane_HOTAS_BoatSwitchForward,									},
	{category = _('HOTAS'), name = _('STT/TWS Toggle'),								down = iCommandPlaneChangeLock,																							},
	{category = _('HOTAS'), name = _('Trim UP'),									pressed = iCommandPlaneTrimUp,				up = iCommandPlaneTrimStop,													},
	{category = _('HOTAS'), name = _('Trim DOWN'),									pressed = iCommandPlaneTrimDown,			up = iCommandPlaneTrimStop,													},
	{category = _('HOTAS'), name = _('Trim LEFT'),									pressed = iCommandPlaneTrimLeft,			up = iCommandPlaneTrimStop,													},
	{category = _('HOTAS'), name = _('Trim RIGHT'),									pressed = iCommandPlaneTrimRight,			up = iCommandPlaneTrimStop,													},
	{category = _('HOTAS'), name = _('Decoy Program release'),						down = iCommandPlaneDropFlareOnce,																						},
	{category = _('HOTAS'), name = _('Autopilot Standby Mode Inverted'),			down = iCommandPlaneAutopilotOverrideOff,	up = iCommandPlaneAutopilotOverrideOn,										},
	{category = _('HOTAS'), name = _('NAV Update/MAGIC unlock'),					down = iCommandPlaneCircuitBreaker_12,																					},
	{category = _('HOTAS'), name = _('Weapons SystemCMD Depress'),					down = 3955, up = 3955, cockpit_device_id = devices.WeaponSystemCommand,	value_down = 0,								},
	{category = _('HOTAS'), name = _('Weapons SystemCMD FWD'),						down = 3955, up = 3955, cockpit_device_id = devices.WeaponSystemCommand,	value_down = 1,								},
	{category = _('HOTAS'), name = _('Weapons SystemCMD AFT'),						down = 3955, up = 3955, cockpit_device_id = devices.WeaponSystemCommand,	value_down = 2,								},
	{category = _('HOTAS'), name = _('Gun Trigger'),								down = device_commands.Command_GUN_TRIGGER,	up = device_commands.Command_GUN_TRIGGER, value_up = 0, value_down = 1,		},
	{category = _('HOTAS'), name = _('BRM Release'),								down = device_commands.Command_BRM_RELEASE,	up = device_commands.Command_BRM_RELEASE, value_up = 0, value_down = 1,		},
	
	--HOTAS Throttle
	{category = _('HOTAS'), name = _('CNM AA Gun'),										down = iCommandPlaneModeCannon,																},
	{category = _('HOTAS'), name = _('Main U/VHF Radio SELECT'),						down = iCommandPlane_HOTAS_MIC_SwitchUp,	up = iCommandPlane_HOTAS_MIC_SwitchOff,			},
	{category = _('HOTAS'), name = _('Aux. UHF Radio SELECT'),							down = iCommandPlane_HOTAS_MIC_SwitchDown,	up = iCommandPlane_HOTAS_MIC_SwitchOff,			},
	{category = _('HOTAS'), name = _('Airbrake TOGGLE'),								down = iCommandPlaneAirBrake,																},
	{category = _('HOTAS'), name = _('Airbrake ON'),									down = iCommandPlaneAirBrakeOn,																},
	{category = _('HOTAS'), name = _('Airbrake OFF'),									down = iCommandPlaneAirBrakeOff,															},
	{category = _('HOTAS'), name = _('Airbrake 2POS'),									pressed = iCommandPlaneAirBrakeOff,			up = iCommandPlaneAirBrakeOn,					},

	{category = _('HOTAS'), name = _('TDC UP'),											pressed = iCommandPlaneRadarUp,				up = iCommandPlaneRadarStop,					},
	{category = _('HOTAS'), name = _('TDC DOWN'),										pressed = iCommandPlaneRadarDown,			up = iCommandPlaneRadarStop,					},
	{category = _('HOTAS'), name = _('TDC LEFT'),										pressed = iCommandPlaneRadarLeft,			up = iCommandPlaneRadarStop,					},
	{category = _('HOTAS'), name = _('TDC RIGHT'),										pressed = iCommandPlaneRadarRight,			up = iCommandPlaneRadarStop,					},
	{category = _('HOTAS'), name = _('Decoy PANIC release'),							down = iCommandPlaneDropChaffOnce,															},
	{category = _('HOTAS'), name = _('Jammer ACTIVATE/Standby Toggle'),					down = iCommandActiveJamming,																},
	{category = _('HOTAS'), name = _('CNM neutral (PCA SELECT)'),						down = iCommandPlaneModeGrid,																},
	{category = _('HOTAS'), name = _('CNM MAGIC'),										down = iCommandPlaneModeFI0,																},
	{category = _('HOTAS'), name = _('Magic Slave/AG Designate/INS Position Update'),	down = iCommandAutoLockOnNearestSurfaceTarget,												},
	{category = _('HOTAS'), name = _('TDC DEPRESS (Lock Target)'),						down = iCommandPlaneRadarCenter,															},
	{category = _('HOTAS'), name = _('Radar Antenna UP'),								pressed = iCommandSelecterUp,				up = iCommandSelecterStop,						},
	{category = _('HOTAS'), name = _('Radar Antenna DOWN'),								pressed = iCommandSelecterDown,				up = iCommandSelecterStop,						},
	{category = _('HOTAS'), name = _('Radar Antenna CENTER'),							pressed = iCommandSelecterLeft,				up = iCommandSelecterStop,						},
	{category = _('HOTAS'), name = _('Police Light Toggle'),							down = iCommandPlaneRotorTipLights,															},
    {category = _('HOTAS'), name = _('Weapons SystemCMD Depress'),						down = 3955, up = 3955, cockpit_device_id = devices.WeaponSystemCommand, value_down = 0,	},
	{category = _('HOTAS'), name = _('Weapons SystemCMD FWD'),							down = 3955, up = 3955, cockpit_device_id = devices.WeaponSystemCommand, value_down = 1,	},
	{category = _('HOTAS'), name = _('Weapons SystemCMD AFT'),							down = 3955, up = 3955, cockpit_device_id = devices.WeaponSystemCommand, value_down = 2,	},
	{category = _('HOTAS'), name = _('Airbrake ON, else OFF'),							down = iCommandPlaneAirBrakeOn,		up = iCommandPlaneAirBrakeOff,							},
	{category = _('HOTAS'), name = _('AA Gun SELECT, else PCA SELECT'),					down = iCommandPlaneModeCannon,		up = iCommandPlaneModeGrid,								},
    {category = _('HOTAS'), name = _('MAGIC SELECT, else PCA SELECT'),					down = iCommandPlaneModeFI0,			up = iCommandPlaneModeGrid,							},
	
	--PCA
	{category = _('PCA Weapons Management'), name = _('Emergency Jettison'),						down = 3409, up = 3409, cockpit_device_id = 6, value_up = 0, value_down = 1,	},
	{category = _('PCA Weapons Management'), name = _('Gun Arm TOGGLE'),							down = iCommandPlaneAHCPGUNArm,													},
	{category = _('PCA Weapons Management'), name = _('Master Arm TOGGLE'),							down = iCommandSwitchMasterArm,													},
	{category = _('PCA Weapons Management'), name = _('PCA Button 1 SELECT'),						down = iCommandPlaneLeftMFD_OSB1,												},
	{category = _('PCA Weapons Management'), name = _('PCA Button 2 SELECT'),						down = iCommandPlaneLeftMFD_OSB2,												},		
	{category = _('PCA Weapons Management'), name = _('PCA Button 3 SELECT'),						down = iCommandPlaneLeftMFD_OSB3,												},
	{category = _('PCA Weapons Management'), name = _('PCA Button 4 SELECT'),						down = iCommandPlaneLeftMFD_OSB4,												},
	{category = _('PCA Weapons Management'), name = _('PCA Button 5 SELECT'),						down = iCommandPlaneLeftMFD_OSB5,												},
	{category = _('PCA Weapons Management'), name = _('AG Gun  SELECT'),							down = iCommandPlaneLeftMFD_OSB6,												},
	{category = _('PCA Weapons Management'), name = _('Stores 1 SELECT'),							down = iCommandPlaneLeftMFD_OSB7,												},
	{category = _('PCA Weapons Management'), name = _('Stores 2 SELECT'),							down = iCommandPlaneLeftMFD_OSB8,												},
	{category = _('PCA Weapons Management'), name = _('Stores 3 SELECT'),							down = iCommandPlaneLeftMFD_OSB9,												},
	{category = _('PCA Weapons Management'), name = _('Stores 4 SELECT'),							down = iCommandPlaneLeftMFD_OSB10,												},
	{category = _('PCA Weapons Management'), name = _('Stores 5 SELECT'),							down = iCommandPlaneLeftMFD_OSB11,												},
	{category = _('PCA Weapons Management'), name = _('Smoke'),										down = iCommandPlaneWingtipSmokeOnOff,											}, 
	{category = _('PCA Weapons Management'), name = _('Selective Jettison ON'),						down = 3249, up = 3249, cockpit_device_id = 6, value_down = 1,					},
	{category = _('PCA Weapons Management'), name = _('Selective Jettison OFF'),					down = 3249, up = 3249, cockpit_device_id = 6, value_down = 0,					},
	{category = _('PCA Weapons Management'), name = _('Selective Jettison Safety Cover OPEN'),		down = 3248, up = 3248, cockpit_device_id = 6, value_down = 1,					},
	{category = _('PCA Weapons Management'), name = _('Selective Jettison Safety Cover CLOSED'),	down = 3248, up = 3248, cockpit_device_id = 6, value_down = 0,					},
	{category = _('PCA Weapons Management'), name = _('Master Arm ARMED'),							down = 3234, cockpit_device_id = 6,	value_down = 1,								},
	{category = _('PCA Weapons Management'), name = _('Master Arm SAFE'),							down = 3234, cockpit_device_id = 6,	value_down = -1,							},
	{category = _('PCA Weapons Management'), name = _('Master ARMED, else SAFE'),					down = 3234, up = 3234, cockpit_device_id = 6, value_up = -1, value_down = 1,	},
    {category = _('PCA Weapons Management'), name = _('Gun ARMED, else SAFE'),						down = 3463, up = 3463, cockpit_device_id = 6, value_up = 0, value_down = 1,	},
    {category = _('PCA Weapons Management'), name = _('Selective Jettison ON, else OFF'),			down = 3249, up = 3249, cockpit_device_id = 6, value_up = 0, value_down = 1,	},
	
    --PPA
    {category = _('PPA Weapons Preparation'), name = _('PPA Test Switch - Test'),							down = 3275, up = 3275, cockpit_device_id = devices.PCA_PPA, value_down = -1, value_up = 0,	},
    {category = _('PPA Weapons Preparation'), name = _('PPA Test Switch - Weapon Loadout'),					down = 3275, up = 3275, cockpit_device_id = devices.PCA_PPA, value_down =  1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('Missile Selector: Fire Left 530D First'),			down = 3265, up = 3265, cockpit_device_id = devices.PCA_PPA, value_down =  1,				},
	{category = _('PPA Weapons Preparation'), name = _('Missile Selector: Automatic 530D Fire Selection'),	down = 3265, up = 3265, cockpit_device_id = devices.PCA_PPA, value_down =  0,				},
	{category = _('PPA Weapons Preparation'), name = _('Missile Selector: Fire Right 530D First'),			down = 3265, up = 3265, cockpit_device_id = devices.PCA_PPA, value_down = -1,				},
	{category = _('PPA Weapons Preparation'), name = _('MIS PREP: Super 530D Standby Toggle'),				down = 3266, up = 3266, cockpit_device_id = devices.PCA_PPA, value_down =  0,				},
	{category = _('PPA Weapons Preparation'), name = _('MAG PREP: MAGIC II Standby Toggle'),				down = 3272, up = 3272, cockpit_device_id = devices.PCA_PPA, value_down =  0,				},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Fuze: INERT'),									down = 3276, up = 3276, cockpit_device_id = devices.PCA_PPA, value_down =  1,				},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Fuze: RET'),									down = 3276, up = 3276, cockpit_device_id = devices.PCA_PPA, value_down =  0.5,				},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Fuze: INST'),									down = 3276, up = 3276, cockpit_device_id = devices.PCA_PPA, value_down =  0,				},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Qty Increase'),								down = 3277, up = 3277, cockpit_device_id = devices.PCA_PPA, value_down =  1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Qty Decrease'),								down = 3277, up = 3277, cockpit_device_id = devices.PCA_PPA, value_down = -1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Release Interval Increase'),					down = 3278, up = 3278, cockpit_device_id = devices.PCA_PPA, value_down = -1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('Bomb Release Interval Decrease'),					down = 3278, up = 3278, cockpit_device_id = devices.PCA_PPA, value_down =  1, value_up = 0,	},
	{category = _('PPA Weapons Preparation'), name = _('530D/Rockets/Guns TOT/PAR Firing Mode Toggle'),		down = 3279, up = 3279, cockpit_device_id = devices.PCA_PPA, value_down =  0,				},
	
	--Radio
    {category = _('Radio'), name = _('UHF MODE AR'),			down = 3950, cockpit_device_id = devices.UHF, value_down = 0.0, },
    {category = _('Radio'), name = _('UHF MODE M'),				down = 3950, cockpit_device_id = devices.UHF, value_down = 0.1, },
    {category = _('Radio'), name = _('UHF MODE F1'),			down = 3950, cockpit_device_id = devices.UHF, value_down = 0.2, },
    {category = _('Radio'), name = _('UHF MODE H'),				down = 3950, cockpit_device_id = devices.UHF, value_down = 0.3, },
	{category = _('Radio'), name = _('UHF MODE Rotate CCW'), 	down = device_commands.Helper_UHF_MODE_INC, value_down=-1.0, 	},
	{category = _('Radio'), name = _('UHF MODE Rotate CW'),  	down = device_commands.Helper_UHF_MODE_INC, value_down=1.0,  	},
	{category = _('Radio'), name = _('UHF Channel Knob Dec'),  	down = device_commands.Helper_UHF_CH_INC, value_down=-1.0, 		},
	{category = _('Radio'), name = _('UHF Channel Knob Inc'),  	down = device_commands.Helper_UHF_CH_INC, value_down=1.0,  		},
    {category = _('Radio'), name = _('V/UHF MODE OFF'),			down = 3950, cockpit_device_id = devices.VHF, value_down = 0.0, },
    {category = _('Radio'), name = _('V/UHF MODE FF'),			down = 3950, cockpit_device_id = devices.VHF, value_down = 0.1, },
    {category = _('Radio'), name = _('V/UHF MODE HQ'),			down = 3950, cockpit_device_id = devices.VHF, value_down = 0.2, },
    {category = _('Radio'), name = _('V/UHF MODE SV'),			down = 3950, cockpit_device_id = devices.VHF, value_down = 0.3, },
    {category = _('Radio'), name = _('V/UHF MODE DL'),			down = 3950, cockpit_device_id = devices.VHF, value_down = 0.4, },
    {category = _('Radio'), name = _('V/UHF MODE G'),			down = 3950, cockpit_device_id = devices.VHF, value_down = 0.5, },
    {category = _('Radio'), name = _('V/UHF MODE EN'),			down = 3950, cockpit_device_id = devices.VHF, value_down = 0.6, },
	{category = _('Radio'), name = _('V/UHF MODE Rotate CCW'), 	down = device_commands.Helper_VUHF_MODE_INC, value_down=-1.0, 	},
	{category = _('Radio'), name = _('V/UHF MODE Rotate CW'),  	down = device_commands.Helper_VUHF_MODE_INC, value_down=1.0,  	},
	{category = _('Radio'), name = _('V/UHF Channel Knob Dec'),	down = device_commands.Helper_VUHF_CH_INC, value_down=-1.0, 	},
	{category = _('Radio'), name = _('V/UHF Channel Knob Inc'),	down = device_commands.Helper_VUHF_CH_INC, value_down=1.0,  	},
	{category = _('Radio'), name = _('V/UHF MEM/CLR'),			down = 3952, up = 3952, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF VLD/XFR'),			down = 3953, up = 3953, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF 1/READ'),			down = 3954, up = 3954, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF 2/SQL'),			down = 3955, up = 3955, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF 3/GR'),				down = 3956, up = 3956, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF 4'),				down = 3957, up = 3957, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF 5/20/LOW'),			down = 3958, up = 3958, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF 6/TONE'),			down = 3959, up = 3959, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF 7'),				down = 3960, up = 3960, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF 8/TOD'),			down = 3961, up = 3961, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF 9/ZERO'),			down = 3962, up = 3962, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF 0'),				down = 3963, up = 3963, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },
	{category = _('Radio'), name = _('V/UHF CONF'),				down = 3964, up = 3964, cockpit_device_id = devices.VHF, value_down = 1, value_up = 0, },  
	

	
	-- Engine & Fuel
	{category = _('Engine & Fuel'), name = _('Engines START'),								down = iCommandLeftEngineStart, 												},
	{category = _('Engine & Fuel'), name = _('Engines STOP'),								down = iCommandLeftEngineStop,  												},
	{category = _('Engine & Fuel'), name = _('Fuel Dump START'),							down = iCommandPlaneFuelOn, up   = iCommandPlaneFuelOff,    					},
	{category = _('Engine & Fuel'), name = _('Left Fuel Boost Pump ON'), 					down = 3647, up = 3647, cockpit_device_id = 4, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Left Fuel Boost Pump OFF'),					down = 3647, up = 3647, cockpit_device_id = 4, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('Right Fuel Boost Pump ON'),					down = 3648, up = 3648, cockpit_device_id = 4, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Right Fuel Boost Pump OFF'),					down = 3648, up = 3648, cockpit_device_id = 4, value_down = 0,   				},
    {category = _('Engine & Fuel'), name = _('Fuel Emergency Cutoff Switch Cover CLOSE'), 	down = 3651, up = 3651, cockpit_device_id = 7, value_down = 0,   				},
    {category = _('Engine & Fuel'), name = _('Fuel Emergency Cutoff Switch Cover OPEN'),	down = 3651, up = 3651, cockpit_device_id = 7, value_down = 1,   				},
    {category = _('Engine & Fuel'), name = _('Fuel Emergency Cutoff Switch ON'),			down = 3652, up = 3652, cockpit_device_id = 7, value_down = 0,   				},
    {category = _('Engine & Fuel'), name = _('Fuel Emergency Cutoff Switch OFF'),			down = 3652, up = 3652, cockpit_device_id = 7, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Start Button Safety Cover CLOSED'),			down = 3645, up = 3645, cockpit_device_id = 7, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('Start Button Safety Cover OPEN'), 			down = 3645, up = 3645, cockpit_device_id = 7, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Starter Fuel Pump ON'),						down = 3646, up = 3646, cockpit_device_id = 7, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Starter Fuel Pump OFF'),						down = 3646, up = 3646, cockpit_device_id = 7, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('Ignition Selector Switch RIGHT'),				down = 3650, up = 3650, cockpit_device_id = 7, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('Ignition Selector Switch LEFT'),				down = 3650, up = 3650, cockpit_device_id = 7, value_down = 0.5, 				},
	{category = _('Engine & Fuel'), name = _('Ignition Selector Switch OFF'),				down = 3650, up = 3650, cockpit_device_id = 7, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('In-Flight Start Switch OFF'),					down = 3468, up = 3468, cockpit_device_id = 7, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('In-Flight Start Switch ON'),					down = 3468, up = 3468, cockpit_device_id = 7, value_down = 1,   				},
    {category = _('Engine & Fuel'), name = _('Air Refuel Transfer Switch OFF '),			down = 3193, up = 3193, cockpit_device_id = 7, value_down = 0,   				},
	{category = _('Engine & Fuel'), name = _('Air Refuel Transfer Switch ON (DAY)'),		down = 3193, up = 3193, cockpit_device_id = 7, value_down = 0.5, 				},
    {category = _('Engine & Fuel'), name = _('Air Refuel Transfer Switch ON (NIGHT)'),		down = 3193, up = 3193, cockpit_device_id = 7, value_down = 1,   				},
    {category = _('Engine & Fuel'), name = _('Afterburner Cutoff Switch Cover CLOSE'),		down = 3471, up = 3471, cockpit_device_id = 4, value_down = 0,   				},
    {category = _('Engine & Fuel'), name = _('Afterburner Cutoff Switch Cover OPEN'),		down = 3471, up = 3471, cockpit_device_id = 4, value_down = 1,   				},
    {category = _('Engine & Fuel'), name = _('Afterburner Cutoff Switch OFF'),				down = 3472, up = 3472, cockpit_device_id = 4, value_down = 0,   				},
    {category = _('Engine & Fuel'), name = _('Afterburner Cutoff Switch ON'),				down = 3472, up = 3472, cockpit_device_id = 4, value_down = 1,   				},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel 1000kg Inc'),						down = device_commands.Helper_BINGO_THOUSANDS_INC, value_down=1.0, 				},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel 1000kg Dec'),						down = device_commands.Helper_BINGO_THOUSANDS_INC, value_down=-1.0,				},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel 100kg Inc'),						down = device_commands.Helper_BINGO_HUNDREDS_INC, value_down=1.0,				},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel 100kg Dec'),						down = device_commands.Helper_BINGO_HUNDREDS_INC, value_down=-1.0,				},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel Combo Inc'), 						down = device_commands.Helper_BINGO_COMBO_INC, value_down=1.0,					},
	{category = _('Engine & Fuel'), name = _('BINGO Fuel Combo Dec'), 						down = device_commands.Helper_BINGO_COMBO_INC, value_down=-1.0,					},
    {category = _('Engine & Fuel'), name = _('Left Fuel Boost Pump ON, else OFF'),			down = 3647, up = 3647, cockpit_device_id = 4, value_down = 1, value_up = 0,	},
    {category = _('Engine & Fuel'), name = _('Right Fuel Boost Pump ON, else OFF'),			down = 3648, up = 3648, cockpit_device_id = 4, value_down = 1, value_up = 0,	},

	-- Flight Control
	{category = _('Flight Control'), name = _('Aircraft Pitch DOWN'), 				pressed = iCommandPlaneUpStart,    up = iCommandPlaneUpStop,    			},
	{category = _('Flight Control'), name = _('Aircraft Pitch UP'),   				pressed = iCommandPlaneDownStart,  up = iCommandPlaneDownStop,  			},
	{category = _('Flight Control'), name = _('Aircraft Bank LEFT'),  				pressed = iCommandPlaneLeftStart,  up = iCommandPlaneLeftStop,  			},
	{category = _('Flight Control'), name = _('Aircraft Bank RIGHT'), 				pressed = iCommandPlaneRightStart, up = iCommandPlaneRightStop, 			},
	{category = _('Flight Control'), name = _('Aircraft Rudder LEFT'),  			pressed = iCommandPlaneLeftRudderStart,  up = iCommandPlaneLeftRudderStop,  },
	{category = _('Flight Control'), name = _('Aircraft Rudder RIGHT'), 			pressed = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, },
	{category = _('Flight Control'), name = _('Throttle UP'),   					pressed = iCommandThrottleIncrease, up = iCommandThrottleStop,  			},
	{category = _('Flight Control'), name = _('Throttle DOWN'), 					pressed = iCommandThrottleDecrease, up = iCommandThrottleStop,  			},
	{category = _('Flight Control'), name = _('Trim RUDDER LEFT'),  				pressed = iCommandPlaneTrimLeftRudder,  up = iCommandPlaneTrimStop, 		},
	{category = _('Flight Control'), name = _('Trim RUDDER RIGHT'), 				pressed = iCommandPlaneTrimRightRudder, up = iCommandPlaneTrimStop, 		},
	{category = _('Flight Control'), name = _('FBW G-Limiter Mode TOGGLE'), 		down = iCommandPlaneCobra,             										},
	{category = _('Flight Control'), name = _('FBW Spin Switch TOGGLE'),    		down = iCommandPlaneEmerFlightControl, 										},
    {category = _('Flight Control'), name = _('Drag Chute DEPLOY'),         		down = iCommandPlaneParachute,  											},
	{category = _('Flight Control'), name = _('Slats RETRACT'), 					down = 3462, up = 3462, cockpit_device_id = 14, value_down = -1, 							},
	{category = _('Flight Control'), name = _('Slats AUTO'),    					down = 3462, up = 3462, cockpit_device_id = 14, value_down = 0,  							},
	{category = _('Flight Control'), name = _('Slats EXTEND'),  					down = 3462, up = 3462, cockpit_device_id = 14, value_down = 1,  							},
	{category = _('Flight Control'), name = _('FBW Gain Cover CLOSED'), 			down = 3420, up = 3420, cockpit_device_id = 3, value_down = 0,   							},
	{category = _('Flight Control'), name = _('FBW Gain Cover OPEN'),   			down = 3420, up = 3420, cockpit_device_id = 3, value_down = 1,   							},
	{category = _('Flight Control'), name = _('FBW Gain NORM'),         			down = 3421, up = 3421, cockpit_device_id = 3, value_down = 0,   							},
	{category = _('Flight Control'), name = _('FBW Gain EMER'),         			down = 3421, up = 3421, cockpit_device_id = 3, value_down = 1,   							},
	{category = _('Flight Control'), name = _('FBW RESET'),        					down = 3423, cockpit_device_id = devices.AFCS, value_down = 1,   							},
	{category = _('Flight Control'), name = _('Slats RETRACT, else AUTO'),			down = 3462, up = 3462, cockpit_device_id = 14,	value_down = -1, value_up = 0,				},
	{category = _('Flight Control'), name = _('Slats EXTEND, else AUTO'),			down = 3462, up = 3462, cockpit_device_id = 14,	value_down = 1, value_up = 0,				},
	{category = _('Flight Control'), name = _('FBW G-Limiter AA else CHARGES'),		down = 3422, up = 3422, cockpit_device_id = devices.ENGINE,	value_down = 0,	value_up = 1,	},
	{category = _('Flight Control'), name = _('FBW Gain NORM, else EMER'),			down = 3421, up = 3421, cockpit_device_id = 3, value_down = 0, value_up = 1,				},
    {category = _('Flight Control'), name = _('FBW Spin Switch NORM, else SPIN'),	down = 3330, up = 3330, cockpit_device_id = 3, value_down = 0, value_up = 1,				},
	
	-- External Lights
	{category = _('External Lights'), name = _('Landing Lights TOGGLE'),       	down = iCommandPlaneHeadLightOnOff,       							},
	{category = _('External Lights'), name = _('Formation Lights TOGGLE'),     	down = iCommandPlaneFormationLights,      							},
	{category = _('External Lights'), name = _('Navigation Lights TOGGLE'),    	down = iCommandPlaneLightsOnOff,          							},
	{category = _('External Lights'), name = _('Anti-Collision Lights TOGGLE'),	down = iCommandPlaneAntiCollisionLights,  							},
	{category = _('External Lights'), name = _('Police Lights Disabled'), 		down = 3449, up = 3449, cockpit_device_id = 16, value_down = 0, 	},
	{category = _('External Lights'), name = _('Police Lights Enabled'),  		down = 3449, up = 3449, cockpit_device_id = 16, value_down = 1, 	},
	{category = _('External Lights'), name = _('Landing Lights OFF'),     		down = 3450, up = 3450, cockpit_device_id = 16, value_down = 0.0, 	},
	{category = _('External Lights'), name = _('Landing Lights TAXI'),    		down = 3450, up = 3450, cockpit_device_id = 16, value_down = 0.5, 	},
	{category = _('External Lights'), name = _('Landing Lights LANDING'), 		down = 3450, up = 3450, cockpit_device_id = 16, value_down = 1.0, 	},
	{category = _('External Lights'), name = _('Refuel Lights Disabled'), 		down = 3452, up = 3452, cockpit_device_id = 16, value_down = 0.0, 	},
	{category = _('External Lights'), name = _('Refuel Lights Enabled'),  		down = 3452, up = 3452, cockpit_device_id = 16, value_down = 1.0, 	},
	{category = _('External Lights'), name = _('Anti-Collision Lights OFF'),   	down = 3453, up = 3453, cockpit_device_id = 16, value_down = 0.0, 	},
    {category = _('External Lights'), name = _('Anti-Collision Lights DIM'),   	down = 3453, up = 3453, cockpit_device_id = 16, value_down = 0.5, 	},
	{category = _('External Lights'), name = _('Anti-Collision Lights BRIGHT'),	down = 3453, up = 3453, cockpit_device_id = 16, value_down = 1.0, 	},
	{category = _('External Lights'), name = _('Navigation Lights OFF'),    	down = 3454, up = 3454, cockpit_device_id = 16, value_down = 0.0, 	},
    {category = _('External Lights'), name = _('Navigation Lights DIM'),    	down = 3454, up = 3454, cockpit_device_id = 16, value_down = 0.5, 	},
	{category = _('External Lights'), name = _('Navigation Lights BRIGHT'), 	down = 3454, up = 3454, cockpit_device_id = 16, value_down = 1.0, 	},
	{category = _('External Lights'), name = _('Formation Lights OFF'),     	down = 3455, up = 3455, cockpit_device_id = 16, value_down = 0.0, 	},
    {category = _('External Lights'), name = _('Formation Lights DIM'),     	down = 3455, up = 3455, cockpit_device_id = 16, value_down = 0.5, 	},
	{category = _('External Lights'), name = _('Formation Lights BRIGHT'),  	down = 3455, up = 3455, cockpit_device_id = 16, value_down = 1.0, 	},
	
	--Radar
	{category = _('RDI Radar'), name = _('Radar Range DECREASE'),				down = iCommandDecreaseRadarScanArea, 													},
	{category = _('RDI Radar'), name = _('Radar Range INCREASE'),				down = iCommandIncreaseRadarScanArea, 													},	
	{category = _('RDI Radar'), name = _('Radar Power CCW'),					down = iCommandPlaneRadarChangeMode, value_down =-1.0, 									},
	{category = _('RDI Radar'), name = _('Radar Power CW'),						down = iCommandPlaneRadarChangeMode, value_down = 1.0, 									},
	{category = _('RDI Radar'), name = _('PRF Selector Low>Int>High'),			down = iCommandHelicopter_PPR_button_B_up, 												},
	{category = _('RDI Radar'), name = _('PRF Selector High>Int>Low'),			down = iCommandHelicopter_PPR_button_B,    												},
	{category = _('RDI Radar'), name = _('PRF Selector Low'),					down = 3109, up = 3109, cockpit_device_id = 11, value_down =-1.0,						},
	{category = _('RDI Radar'), name = _('PRF Selector Int'),					down = 3109, up = 3109, cockpit_device_id = 11, value_down = 0.0,						},
	{category = _('RDI Radar'), name = _('PRF Selector High'),					down = 3109, up = 3109, cockpit_device_id = 11, value_down = 1.0,						},
	{category = _('RDI Radar'), name = _('Radar Azimuth WIDE'),					down = 3506, up = 3506, cockpit_device_id = 11, value_down = 0.0,						},
	{category = _('RDI Radar'), name = _('Radar Azimuth MIDDLE'),				down = 3506, up = 3506, cockpit_device_id = 11, value_down = 0.5,						},
	{category = _('RDI Radar'), name = _('Radar Azimuth NARROW'),				down = 3506, up = 3506, cockpit_device_id = 11, value_down = 1.0,						},
	{category = _('RDI Radar'), name = _('Radar Scan 4-LINE'),					down = 3502, up = 3502, cockpit_device_id = 11, value_down = 0.0,						},
	{category = _('RDI Radar'), name = _('Radar Scan 2-LINE'),					down = 3502, up = 3502, cockpit_device_id = 11, value_down = 0.5,						},
	{category = _('RDI Radar'), name = _('Radar Scan 1-LINE'),					down = 3502, up = 3502, cockpit_device_id = 11, value_down = 1.0,						},
	{category = _('RDI Radar'), name = _('Radar Power A Off'),					down = 3486, up = 3486, cockpit_device_id = 11, value_down = 0.0,						},
	{category = _('RDI Radar'), name = _('Radar Power PCH Warm-up'), 			down = 3486, up = 3486, cockpit_device_id = 11, value_down = .33,						},
	{category = _('RDI Radar'), name = _('Radar Power SIL Standby'), 			down = 3486, up = 3486, cockpit_device_id = 11, value_down = .67,						},
	{category = _('RDI Radar'), name = _('Radar Power EM On'),					down = 3486, up = 3486, cockpit_device_id = 11, value_down = 1.0,						},
	{category = _('RDI Radar'), name = _('Radar PPI Mode'), 					down = 3499, up = 3499, cockpit_device_id = 11, value_down = 0.0,						},
	{category = _('RDI Radar'), name = _('Radar B-Scope Mode'), 				down = 3499, up = 3499, cockpit_device_id = 11, value_down = 1.0,						},
	{category = _('RDI Radar'), name = _('TDC Mode Switch S'),					down = 3710, up = 3710, cockpit_device_id = 11, value_down = 0.0,						},
	{category = _('RDI Radar'), name = _('TDC Mode Switch Z'),					down = 3710, up = 3710, cockpit_device_id = 11, value_down = 1.0,						},
	{category = _('RDI Radar'), name = _('Radar Azimuth WIDE, else MIDDLE'),	down = 3506, up = 3506, cockpit_device_id = 11,	value_down = 0,		value_up = 0.5,		},
	{category = _('RDI Radar'), name = _('Radar Azimuth NARROW, else MIDDLE'),	down = 3506, up = 3506, cockpit_device_id = 11,	value_down = 1,		value_up = 0.5,		},
	{category = _('RDI Radar'), name = _('Radar Scan 4-LINE, else 2-LINE'),		down = 3502, up = 3502, cockpit_device_id = 11,	value_down = 0,		value_up = 0.5,		},
	{category = _('RDI Radar'), name = _('Radar Scan 1-LINE, else 2-LINE'),		down = 3502, up = 3502, cockpit_device_id = 11,	value_down = 1,		value_up = 0.5,		},
	{category = _('RDI Radar'), name = _('Radar PPI Mode, else B-Scope Mode'),	down = 3499, up = 3499, cockpit_device_id = 11,	value_down = 0,		value_up = 1,		},
	{category = _('RDI Radar'), name = _('Radar Altimeter ON, else OFF'),		down = 3205, up = 3205, cockpit_device_id = 5,		value_down = 0.5,	value_up = 0,	},
	{category = _('RDI Radar'), name = _('PRF Selector Low, else Int'),			down = 3109, up = 3109, cockpit_device_id = 11,	value_down = -1,	value_up = 0,		},
	{category = _('RDI Radar'), name = _('PRF Selector High, else Int'),		down = 3109, up = 3109, cockpit_device_id = 11,	value_down = 1,		value_up = 0,		},
    {category = _('RDI Radar'), name = _('Radar ON, else STANDBY'),				down = 3486, up = 3486, cockpit_device_id = 11,	value_up = 0.67,	value_down = 1,		},
    {category = _('RDI Radar'), name = _('Radar WARM UP, else OFF'),			down = 3486, up = 3486, cockpit_device_id = 11,	value_up = 0,		value_down = 0.33,	},
	{category = _('RDI Radar'), name = _('TDC Mode S, else Z'),					down = 3710, up = 3710, cockpit_device_id = 11,	value_down = 0,		value_up = 1,		},

	--IFF
	{category = _('IFF'), name = _('IFF Mode 1'),		down = 3598, up = 3598, cockpit_device_id = 11, value_down = 0.0, },
	{category = _('IFF'), name = _('IFF Mode 4'),		down = 3598, up = 3598, cockpit_device_id = 11, value_down = 0.2, },
	{category = _('IFF'), name = _('IFF Mode 3/2'),		down = 3598, up = 3598, cockpit_device_id = 11, value_down = 0.4, },
	{category = _('IFF'), name = _('IFF Mode 3/3'),		down = 3598, up = 3598, cockpit_device_id = 11, value_down = 0.6, },
	{category = _('IFF'), name = _('IFF Mode 3/4'),		down = 3598, up = 3598, cockpit_device_id = 11, value_down = 0.8, },
	{category = _('IFF'), name = _('IFF Mode 2'),		down = 3598, up = 3598, cockpit_device_id = 11, value_down = 1.0, },
	{category = _('IFF'), name = _('IFF L Selector'),	down = 3599, up = 3599, cockpit_device_id = 11, value_down = 0.0, },
	{category = _('IFF'), name = _('IFF R Selector'),	down = 3599, up = 3599, cockpit_device_id = 11, value_down = 1.0, },
	{category = _('IFF'), name = _('IFF OFF'),			down = 3600, up = 3600, cockpit_device_id = 11, value_down = 0.0, },
	{category = _('IFF'), name = _('IFF SECTOR'),		down = 3600, up = 3600, cockpit_device_id = 11, value_down = 0.5, },
	{category = _('IFF'), name = _('IFF CONT'),			down = 3600, up = 3600, cockpit_device_id = 11, value_down = 1.0, },
	
	--Countermeasures
	{category = _('Countermeasures'), name = _('Decoy Release Program Knob Up'),	down = iCommandPlaneCMDChangeRippleQuantity,    					},
	{category = _('Countermeasures'), name = _('Decoy Release Program Knob Down'),	down = iCommandPlaneCMDChangeRippleQuantityOff, 					},
	{category = _('Countermeasures'), name = _('RWR OFF'),  						down = 3607, up = 3607, cockpit_device_id = 13, value_down = 0,		},
    {category = _('Countermeasures'), name = _('RWR ON'),   						down = 3607, up = 3607, cockpit_device_id = 13, value_down = 0.5,	},
    {category = _('Countermeasures'), name = _('RWR TEST'), 						down = 3607, up = 3607, cockpit_device_id = 13, value_down = 1.0,	},
	{category = _('Countermeasures'), name = _('D2M OFF'),  						down = 3608, up = 3608, cockpit_device_id = 28, value_down = 0.0,	},
    {category = _('Countermeasures'), name = _('D2M ON'),   						down = 3608, up = 3608, cockpit_device_id = 28, value_down = 0.5,	},
    {category = _('Countermeasures'), name = _('D2M TEST'), 						down = 3608, up = 3608, cockpit_device_id = 28, value_down = 1.0,	},
	{category = _('Countermeasures'), name = _('Decoy Release Mode OFF'),			down = 3609, up = 3609, cockpit_device_id = 13, value_down = 0.0,	},
    {category = _('Countermeasures'), name = _('Decoy Release Mode Semi-Auto'),		down = 3609, up = 3609, cockpit_device_id = 13, value_down = 0.5,	},
    {category = _('Countermeasures'), name = _('Decoy Release Mode Automatic'),		down = 3609, up = 3609, cockpit_device_id = 13, value_down = 1.0,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program OFF'),		down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.0,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program 01'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.1,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program 02'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.2,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program 03'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.3,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program 04'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.4,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program 05'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.5,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program 06'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.6,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program 07'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.7,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program 08'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.8,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program 09'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 0.9,	},
	{category = _('Countermeasures'), name = _('Decoy Release Program 10'),			down = 3610, up = 3610, cockpit_device_id = 13, value_down = 1.0,	},
	{category = _('Countermeasures'), name = _('Jammer OFF'),						down = 3606, up = 3606, cockpit_device_id = 13, value_down = 0.0,	},
	{category = _('Countermeasures'), name = _('Jammer ON'),						down = 3606, up = 3606, cockpit_device_id = 13, value_down = 0.5,	},
	{category = _('Countermeasures'), name = _('Jammer TEST'),						down = 3606, up = 3606, cockpit_device_id = 13, value_down = 1.0,	},
	{category = _('Countermeasures'), name = _('Jammer Mode Veille'),				down = 3605, up = 3605, cockpit_device_id = 13, value_down =-1.0,	},
	{category = _('Countermeasures'), name = _('Jammer Mode []'),					down = 3605, up = 3605, cockpit_device_id = 13, value_down = 0.0,	},
	{category = _('Countermeasures'), name = _('Jammer Mode PCM'),					down = 3605, up = 3605, cockpit_device_id = 13, value_down = 1.0,	},
	
    -- Electrical
	{category = _('Electrical'), name = _('Main Battery TOGGLE'), 			down = iCommandBatteryPower, 													},
    {category = _('Electrical'), name = _('Master Caution RESET'), 			down = iCommandPlaneResetMasterWarning, up = iCommandPlaneResetMasterWarning,	},
	{category = _('Electrical'), name = _('Main Battery OFF'),				down = 3520, up = 3520, cockpit_device_id = 8,  value_down= 0.0, 				},
	{category = _('Electrical'), name = _('Main Battery ON'),				down = 3520, up = 3520, cockpit_device_id = 8,  value_down= 1.0, 				},
	{category = _('Electrical'), name = _('Electric Power Transfer OFF'),	down = 3521, up = 3521, cockpit_device_id = 8,  value_down= 0.0, 				},
	{category = _('Electrical'), name = _('Electric Power Transfer ON'),	down = 3521, up = 3521, cockpit_device_id = 8,  value_down= 1.0, 				},
	{category = _('Electrical'), name = _('Alternator 1 OFF'),				down = 3522, up = 3522, cockpit_device_id = 8,  value_down= 0.0, 				},
	{category = _('Electrical'), name = _('Alternator 1 ON'),				down = 3522, up = 3522, cockpit_device_id = 8,  value_down= 1.0, 				},
	{category = _('Electrical'), name = _('Alternator 2 OFF'),				down = 3523, up = 3523, cockpit_device_id = 8,  value_down= 0.0, 				},
	{category = _('Electrical'), name = _('Alternator 2 ON'),				down = 3523, up = 3523, cockpit_device_id = 8,  value_down= 1.0, 				},
	{category = _('Electrical'), name = _('Audio Warning Switch OFF'),		down = 3658, up = 3658, cockpit_device_id = 16, value_down= 0.0, 				},
	{category = _('Electrical'), name = _('Audio Warning Switch ON'),		down = 3658, up = 3658, cockpit_device_id = 16, value_down= 0.5, 				},
	{category = _('Electrical'), name = _('Audio Warning Switch Test?'),	down = 3658, up = 3658, cockpit_device_id = 16, value_down= 1.0, 				},
    {category = _('Electrical'), name = _('Pitot Heat Cover Closed'), 		down = 3659, up = 3659, cockpit_device_id = 22, value_down= 0.0, 				},
    {category = _('Electrical'), name = _('Pitot Heat Cover Opened'), 		down = 3659, up = 3659, cockpit_device_id = 22, value_down= 1.0, 				},
    {category = _('Electrical'), name = _('Pitot Heat Switch OFF'),   		down = 3660, up = 3660, cockpit_device_id = 22, value_down= 1.0, 				},
    {category = _('Electrical'), name = _('Pitot Heat Switch ON'),    		down = 3660, up = 3660, cockpit_device_id = 22, value_down= 0.0, 				},

    -- Interior Lights
    {category = _('Interior Lights'), name = _('Console Flood Lights TOGGLE'), 		down = iCommandPlaneCockpitIlluminationPanels, 									},
    {category = _('Interior Lights'), name = _('Dashboard Flood Lights OFF'),    	down = 3639, up = 3639, cockpit_device_id = 16, value_down = 0,   				},
    {category = _('Interior Lights'), name = _('Dashboard Flood Lights LOW'),    	down = 3639, up = 3639, cockpit_device_id = 16, value_down = .33, 				},
    {category = _('Interior Lights'), name = _('Dashboard Flood Lights MEDIUM'), 	down = 3639, up = 3639, cockpit_device_id = 16, value_down = .67, 				},
    {category = _('Interior Lights'), name = _('Dashboard Flood Lights HIGH'),   	down = 3639, up = 3639, cockpit_device_id = 16, value_down = 1,   				},
    {category = _('Interior Lights'), name = _('Dashboard Panel Lights OFF'),    	down = 3640, up = 3640, cockpit_device_id = 16, value_down = 0,   				},
    {category = _('Interior Lights'), name = _('Dashboard Panel Lights LOW'),    	down = 3640, up = 3640, cockpit_device_id = 16, value_down = .33, 				},
    {category = _('Interior Lights'), name = _('Dashboard Panel Lights MEDIUM'), 	down = 3640, up = 3640, cockpit_device_id = 16, value_down = .67, 				},
    {category = _('Interior Lights'), name = _('Dashboard Panel Lights HIGH'),   	down = 3640, up = 3640, cockpit_device_id = 16, value_down = 1,   				},
	{category = _('Interior Lights'), name = _('Console Flood Lights OFF'),      	down = 3641, up = 3641, cockpit_device_id = 16, value_down = 0,   				},
    {category = _('Interior Lights'), name = _('Console Flood Lights LOW'),      	down = 3641, up = 3641, cockpit_device_id = 16, value_down = .33, 				},
    {category = _('Interior Lights'), name = _('Console Flood Lights MEDIUM'),   	down = 3641, up = 3641, cockpit_device_id = 16, value_down = .67, 				},
    {category = _('Interior Lights'), name = _('Console Flood Lights HIGH'),     	down = 3641, up = 3641, cockpit_device_id = 16, value_down = 1,   				},
    {category = _('Interior Lights'), name = _('Console Panel Lights OFF'),      	down = 3642, up = 3642, cockpit_device_id = 16, value_down = 0,   				},
    {category = _('Interior Lights'), name = _('Console Panel Lights LOW'),      	down = 3642, up = 3642, cockpit_device_id = 16, value_down = .33, 				},
    {category = _('Interior Lights'), name = _('Console Panel Lights MEDIUM'),   	down = 3642, up = 3642, cockpit_device_id = 16, value_down = .67, 				},
    {category = _('Interior Lights'), name = _('Console Panel Lights HIGH'),     	down = 3642, up = 3642, cockpit_device_id = 16, value_down = 1,   				},
    {category = _('Interior Lights'), name = _('Warning Lights TEST'), 				down = 3524, up = 3524, cockpit_device_id = 8, value_up= 0, value_down= 1, 		},
	{category = _('Interior Lights'), name = _('NVG Lights Filter ON else OFF'),	down = 3672, up = 3672, cockpit_device_id = 16, value_down = 1, value_up = 0,	},

	
	-- VTH
    {category = _('HUD'), name = _('HUD Brightness UP'), 				pressed = iCommandHUDBrightnessUp,    											},
    {category = _('HUD'), name = _('HUD Brightness DOWN'), 				pressed = iCommandHUDBrightnessDown, 											},
    {category = _('HUD'), name = _('HUD OFF'), 							down = 3201, up = 3201, cockpit_device_id = devices.VTH_VTB, value_down = 0.0, 	},
    {category = _('HUD'), name = _('HUD ON'), 							down = 3201, up = 3201, cockpit_device_id = devices.VTH_VTB, value_down = 0.5, 	},
    {category = _('HUD'), name = _('HUD TEST'), 						down = 3201, up = 3201, cockpit_device_id = devices.VTH_VTB, value_down = 1.0, 	},
	{category = _('HUD'), name = _('HUD Declutter Switch OFF'), 		down = 3203, up = 3203, cockpit_device_id = devices.VTH_VTB, value_down = 0.0, 	},
	{category = _('HUD'), name = _('HUD Declutter Switch ON'), 			down = 3203, up = 3203, cockpit_device_id = devices.VTH_VTB, value_down = 1.0, 	},
    {category = _('HUD'), name = _('Radar Screen OFF'), 				down = 3221, up = 3221, cockpit_device_id = devices.VTH_VTB, value_down = 0.0, 	},
    {category = _('HUD'), name = _('Radar Screen ON'), 					down = 3221, up = 3221, cockpit_device_id = devices.VTH_VTB, value_down = 1.0, 	},
    {category = _('HUD'), name = _('HUD OFF'),  						down = 3201, up = 3201, cockpit_device_id = devices.VTH_VTB, value_down = 0.0, 	},
    {category = _('HUD'), name = _('HUD ON'),   						down = 3201, up = 3201, cockpit_device_id = devices.VTH_VTB, value_down = 0.5, 	},
    {category = _('HUD'), name = _('HUD TEST'), 						down = 3201, up = 3201, cockpit_device_id = devices.VTH_VTB, value_down = 1.0, 	},
	{category = _('HUD'), name = _('HUD Declutter Switch OFF'), 		down = 3203, up = 3203, cockpit_device_id = devices.VTH_VTB, value_down = 0.0, 	},
	{category = _('HUD'), name = _('HUD Declutter Switch ON'), 			down = 3203, up = 3203, cockpit_device_id = devices.VTH_VTB, value_down = 1.0, 	},
	{category = _('HUD'), name = _('HUD Altimeter Power Switch OFF'), 	down = 3204, up = 3204, cockpit_device_id = devices.VTH_VTB, value_down = 0.0, 	},
	{category = _('HUD'), name = _('HUD Altimeter Power Switch ON'), 	down = 3204, up = 3204, cockpit_device_id = devices.VTH_VTB, value_down = 0.5, 	},
	{category = _('HUD'), name = _('HUD Altimeter Power Switch TEST'), 	down = 3204, up = 3204, cockpit_device_id = devices.VTH_VTB, value_down = 1.0, 	},
    {category = _('HUD'), name = _('Radar Altimeter OFF'), 				down = 3205, up = 3205, cockpit_device_id = devices.VTH_VTB, value_down = 0.0, 	},
    {category = _('HUD'), name = _('Radar Altimeter ON'), 				down = 3205, up = 3205, cockpit_device_id = devices.VTH_VTB, value_down = 0.5, 	},
    {category = _('HUD'), name = _('Radar Altimeter TEST'), 			down = 3205, up = 3205, cockpit_device_id = devices.VTH_VTB, value_down = 1.0, 	},
	{category = _('HUD'), name = _('Auxiliary Gunsight OFF'),			down = 3206, up = 3206, cockpit_device_id = devices.VTH_VTB, value_down = 0.0,	},
	{category = _('HUD'), name = _('Auxiliary Gunsight ON'),			down = 3206, up = 3206, cockpit_device_id = devices.VTH_VTB, value_down = 1.0,	},

	-- VTB
    {category = _('HDD'), name = _('VTB Viewport ON/OFF'), 											down = iCommandPlaneCDU_CLR, 																	},
    {category = _('HDD'), name = _('HDD Zoom IN'),         											down = iCommandPlaneZoomIn,  																	},
    {category = _('HDD'), name = _('HDD Zoom OUT'),        											down = iCommandPlaneZoomOut, 																	},
    {category = _('HDD'), name = _('Radar Screen OFF'),												down = 3221, up = 3221, cockpit_device_id = devices.VTH_VTB, value_down =  0,    				},
    {category = _('HDD'), name = _('Radar Screen ON'), 												down = 3221, up = 3221, cockpit_device_id = devices.VTH_VTB, value_down =  1,    				},
	{category = _('HDD'), name = _('Radar Target Data Manual Entry Begin'),							down = 3213, up = 3213, cockpit_device_id = devices.VTH_VTB, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('Radar Target Data Manual Entry Ends'),							down = 3213, up = 3213, cockpit_device_id = devices.VTH_VTB, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('N Switch (Waypoint Selector Increase)'),						down = 3214, up = 3214, cockpit_device_id = devices.VTH_VTB, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('N Switch (Waypoint Selector Decrease)'),						down = 3214, up = 3214, cockpit_device_id = devices.VTH_VTB, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('Rho Switch Up (Target Range from Bullseye Increase)'),			down = 3215, up = 3215, cockpit_device_id = devices.VTH_VTB, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('Rho Switch Down (Target Range from Bullseye Decrease)'),		down = 3215, up = 3215, cockpit_device_id = devices.VTH_VTB, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('Theta Switch Up (Target Bearing from Bullsweye Increase)'),		down = 3216, up = 3216, cockpit_device_id = devices.VTH_VTB, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('Theta Switch Down (Target Bearing from Bullseye Decrease)'),	down = 3216, up = 3216, cockpit_device_id = devices.VTH_VTB, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('C Switch Up (Target Heading Increase)'),						down = 3217, up = 3217, cockpit_device_id = devices.VTH_VTB, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('C Switch Down (Target Heading Decrease)'),						down = 3217, up = 3217, cockpit_device_id = devices.VTH_VTB, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('Z Switch Up (Target Altitude Increase)'),						down = 3218, up = 3218, cockpit_device_id = devices.VTH_VTB, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('Z Switch Down (Target Altitude Decrease)'),						down = 3218, up = 3218, cockpit_device_id = devices.VTH_VTB, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('M Switch Up (Target Mach Number Increase)'),					down = 3219, up = 3219, cockpit_device_id = devices.VTH_VTB, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('M Switch Down (Target Mach Number Decrease)'),					down = 3219, up = 3219, cockpit_device_id = devices.VTH_VTB, value_down = -1,	value_up = 0,	},
    {category = _('HDD'), name = _('T Switch (Target Age Increase)'),								down = 3220, up = 3220, cockpit_device_id = devices.VTH_VTB, value_down =  1,	value_up = 0,	},
	{category = _('HDD'), name = _('T Switch (Target Age Decrease)'),								down = 3220, up = 3220, cockpit_device_id = devices.VTH_VTB, value_down = -1,	value_up = 0,	},
	
    -- Hydraulic & Mechanical
    {category = _('Hydraulic & Mechanical'), name = _('Wheel Brakes'), 					down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, 				},
    {category = _('Hydraulic & Mechanical'), name = _('Wheel Brake LEFT'), 				down = iCommandPlaneWheelBrakeLeftOn, up = iCommandPlaneWheelBrakeLeftOff, 		},
    {category = _('Hydraulic & Mechanical'), name = _('Wheel Brake RIGHT'), 			down = iCommandPlaneWheelBrakeRightOn, up = iCommandPlaneWheelBrakeRightOff,	},
    {category = _('Hydraulic & Mechanical'), name = _('Landing Gear UP'), 				down = iCommandPlaneGearUp, 													},
    {category = _('Hydraulic & Mechanical'), name = _('Landing Gear DOWN'), 			down = iCommandPlaneGearDown, 													},
    {category = _('Hydraulic & Mechanical'), name = _('Canopy Position CYCLE'), 		down = iCommandPlaneFonar, 														},
    {category = _('Hydraulic & Mechanical'), name = _('Landing Gear TOGGLE'), 			down = iCommandPlaneGear, 														},
    {category = _('Hydraulic & Mechanical'), name = _('Hydraulic Emergency Pump OFF'),	down = 3657, up = 3657, cockpit_device_id = 3, value_down= 0, 					},
    {category = _('Hydraulic & Mechanical'), name = _('Hydraulic Emergency Pump ON'),	down = 3657, up = 3657, cockpit_device_id = 3, value_down= 1, 					},
    {category = _('Hydraulic & Mechanical'), name = _('Parking Brake OFF'),				down = 3666, up = 3666, cockpit_device_id = 22, value_down= 0,  				},
    {category = _('Hydraulic & Mechanical'), name = _('Parking Brake ON'), 				down = 3666, up = 3666, cockpit_device_id = 22, value_down= 1, 					},
	{category = _('Hydraulic & Mechanical'), name = _('Canopy Jettision'), 				down = 3456, up = 3456, cockpit_device_id = 14, value_down= 1, 					},
	{category = _('Hydraulic & Mechanical'), name = _('Landing Gear UP, else DOWN'),	down = iCommandPlaneGearUp,			up = iCommandPlaneGearDown,					},
	{category = _('Hydraulic & Mechanical'), name = _('Parking Brake ON, else OFF'),	down = 3666, up = 3666, cockpit_device_id = 22,	value_down = 1,	value_up = 0,	},

    -- Navigation
    {category = _('Navigation'), name = ('Next Waypoint'),     				down = iCommandPlaneNav_PB0, 																											},
    {category = _('Navigation'), name = ('Previous Waypoint'), 				down = iCommandPlaneNav_PB1, 																											},	
    {category = _('Navigation'), name = _('Altimeter Calibration CW'),		down = iCommandAltimeterPressureIncrease, 																								},
    {category = _('Navigation'), name = _('Altimeter Calibration CCW'),		down = iCommandAltimeterPressureDecrease, 																								},
	{category = _('Navigation'), name = _('HSI Mode 1 - Nav Cv'), 			down = 3341, cockpit_device_id = 2, value_down = 0.0, 																					},
	{category = _('Navigation'), name = _('HSI Mode 2 - Nav'), 				down = 3341, cockpit_device_id = 2, value_down = 0.1, 																					},
	{category = _('Navigation'), name = _('HSI Mode 3 - TAC'), 				down = 3341, cockpit_device_id = 2, value_down = 0.2, 																					},
	{category = _('Navigation'), name = _('HSI Mode 4 - VAD'), 				down = 3341, cockpit_device_id = 2, value_down = 0.3, 																					},
	{category = _('Navigation'), name = _('HSI Mode 5 - VAD ρ'), 			down = 3341, cockpit_device_id = 2, value_down = 0.4, 																					},
	{category = _('Navigation'), name = _('HSI Mode 6 - VAD θ'), 			down = 3341, cockpit_device_id = 2, value_down = 0.5, 																					},
	{category = _('Navigation'), name = _('HSI Mode 7 - TEL'), 				down = 3341, cockpit_device_id = 2, value_down = 0.6, 																					},
	{category = _('Navigation'), name = _('HSI Mode CCW'), 					down = device_commands.Helper_HSI_MODE_INC, value_down = 1.0,																			},
	{category = _('Navigation'), name = _('HSI Mode CW'),  					down = device_commands.Helper_HSI_MODE_INC, value_down =-1.0,																			},
	{category = _('Navigation'), name = _('HSI VAD -'), 					down = 3340, up = 3340, cockpit_device_id = 2, value_down =-1.0, value_up = 0.0, 														},
	{category = _('Navigation'), name = _('HSI VAD +'), 					down = 3340, up = 3340, cockpit_device_id = 2, value_down = 1.0, value_up = 0.0, 														},
	{category = _('Navigation'), name = _('HSI VAD STEP -'), 				down = device_commands.Helper_HSI_VAD_INC, value_down =-1.0, 																			},
	{category = _('Navigation'), name = _('HSI VAD STEP +'), 				down = device_commands.Helper_HSI_VAD_INC, value_down = 1.0, 																			},
	{category = _('Navigation'), name = _('Backup ADI Uncage Lock Toggle'), down = device_commands.Helper_ADI_CAGEUNLOCK_TOGGLE, value_down = 1.0, 																	},
	{category = _('Navigation'), name = _('Backup ADI Uncage Lock Pull'), 	down = device_commands.Helper_ADI_CAGEUNLOCK_PULL, up = device_commands.Helper_ADI_CAGEUNLOCK_PULL, value_down = 1.0, value_up = 0.0, 	},
	{category = _('Navigation'), name = _('Backup ADI Pitch Adjust CCW'), 	down = iCommandADI_ZeroPitchTrimLeft,  value_down = 0.05, 																				},
	{category = _('Navigation'), name = _('Backup ADI Pitch Adjust CW'),  	down = iCommandADI_ZeroPitchTrimRight, value_down = 0.05, 																				},
    {category = _('Navigation'), name = _('Backup Horizon AFT/OFF'), 		down = 3665, cockpit_device_id = devices.PCN_NAV, value_down = 0.0																		},
    {category = _('Navigation'), name = _('Backup Horizon MID/POWERED'),	down = 3665, cockpit_device_id = devices.PCN_NAV, value_down = 0.5																		},
    {category = _('Navigation'), name = _('Backup Horizon FWD/FORCED'),		down = 3665, cockpit_device_id = devices.PCN_NAV, value_down = 1.0																		},
	{category = _('Navigation'), name = _('Backup Horizon FWD/FORCED, else MID/POWERED'),	down = 3665, up = 3665, cockpit_device_id = devices.PCN_NAV, value_down = 1.0,	value_up = 0.5,							},
	{category = _('Navigation'), name = _('Backup Horizon AFT/OFF, else MID/POWERED'),		down = 3665, up = 3665, cockpit_device_id = devices.PCN_NAV, value_down = 0.0,	value_up = 0.5,							},

    -- Autopilot
    {category = _('Autopilot'), name = _('Autopilot'), 					down = iCommandPlaneAutopilot, 										},
    {category = _('Autopilot'), name = _('Altitude Hold Mode'), 		down = iCommandPlaneStabHbar, 										},
    {category = _('Autopilot'), name = _('Selected Altitude Hold Mode'),down = iCommandPlaneSAUHBarometric, 								},
    {category = _('Autopilot'), name = _('Approach Hold Mode'),			down = iCommandPlaneRouteAutopilot, 								},
	{category = _('Autopilot'), name = _('Selected Alt FL 100 Inc'), 	down = device_commands.Helper_SEL_ALT_FL100_INC, value_down=1.0,  	},
	{category = _('Autopilot'), name = _('Selected Alt FL 100 Dec'), 	down = device_commands.Helper_SEL_ALT_FL100_INC, value_down=-1.0, 	},
	{category = _('Autopilot'), name = _('Selected Alt FL 10 Inc'), 	down = device_commands.Helper_SEL_ALT_FL10_INC, value_down=1.0,  	},
	{category = _('Autopilot'), name = _('Selected Alt FL 10 Dec'), 	down = device_commands.Helper_SEL_ALT_FL10_INC, value_down=-1.0, 	},
	{category = _('Autopilot'), name = _('Selected Alt FL 1 Inc'), 		down = device_commands.Helper_SEL_ALT_FL1_INC, value_down=1.0,  	},
	{category = _('Autopilot'), name = _('Selected Alt FL 1 Dec'), 		down = device_commands.Helper_SEL_ALT_FL1_INC, value_down=-1.0, 	},
	{category = _('Autopilot'), name = _('Selected Alt Combo FL+10'), 	down = device_commands.Helper_SEL_ALT_COMBO_INC, value_down=10.0,  	},
	{category = _('Autopilot'), name = _('Selected Alt Combo FL-10'),	down = device_commands.Helper_SEL_ALT_COMBO_INC, value_down=-10.0, 	},
	
	-- INS
    {category = _('INS'), name = _('PCN BAD Button'), 				down = iCommandPlaneNav_PB2 },
    {category = _('INS'), name = _('PCN REC Button'), 				down = iCommandPlaneNav_PB3 },
	{category = _('INS'), name = _('PCN MRQ Button'), 				down = iCommandPlaneNav_PB4 },
	{category = _('INS'), name = _('PCN VAL Button'), 				down = iCommandPlaneNav_PB5 },
    {category = _('INS'), name = _('PCN PREP Button'), 				down = 3570, up = 3570, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN DEST Button'), 				down = 3572, up = 3572, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN ENTER Button'), 			down = 3596, up = 3596, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Clear Button'), 			down = 3594, up = 3594, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Button 0'), 				down = 3593, up = 3593, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Button 1'), 				down = 3584, up = 3584, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Button 2'), 				down = 3585, up = 3585, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Button 3'), 				down = 3586, up = 3586, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Button 4'), 				down = 3587, up = 3587, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Button 5'), 				down = 3588, up = 3588, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Button 6'), 				down = 3589, up = 3589, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Button 7'), 				down = 3590, up = 3590, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Button 8'), 				down = 3591, up = 3591, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Button 9'), 				down = 3592, up = 3592, cockpit_device_id = 9, value_up= 0, value_down = 1 },
    {category = _('INS'), name = _('PCN Parameter TR/VS'), 			down = 3574, cockpit_device_id = 9, value_down = 0.0 },
    {category = _('INS'), name = _('PCN Parameter D/RLT'), 			down = 3574, cockpit_device_id = 9, value_down = 0.1 },
    {category = _('INS'), name = _('PCN Parameter CP/PD'), 			down = 3574, cockpit_device_id = 9, value_down = 0.2 },
    {category = _('INS'), name = _('PCN Parameter ALT'), 			down = 3574, cockpit_device_id = 9, value_down = 0.3 },
    {category = _('INS'), name = _('PCN Parameter L/G'), 			down = 3574, cockpit_device_id = 9, value_down = 0.4 },
    {category = _('INS'), name = _('PCN Parameter RD/TD'), 			down = 3574, cockpit_device_id = 9, value_down = 0.5 },
    {category = _('INS'), name = _('PCN Parameter ΔL/ΔG'), 			down = 3574, cockpit_device_id = 9, value_down = 0.6 },
    {category = _('INS'), name = _('PCN Parameter ΔALT'), 			down = 3574, cockpit_device_id = 9, value_down = 0.7 },
    {category = _('INS'), name = _('PCN Parameter P/Ө'), 			down = 3574, cockpit_device_id = 9, value_down = 0.8 },
    {category = _('INS'), name = _('PCN Parameter DEC'), 			down = 3574, cockpit_device_id = 9, value_down = 0.9 },
    {category = _('INS'), name = _('PCN Parameter DV/FV'), 			down = 3574, cockpit_device_id = 9, value_down = 1.0 },
	{category = _('INS'), name = _('PCN Parameter CCW'), 			down = device_commands.Helper_INSParamSelect_INC, value_down=-1.0	},
	{category = _('INS'), name = _('PCN Parameter CW'), 			down = device_commands.Helper_INSParamSelect_INC, value_down=1.0	},
    {category = _('INS'), name = _('INS Mode Selector - OFF (AR)'), down = 3627, cockpit_device_id = 9, value_down = 0.0},
    {category = _('INS'), name = _('INS Mode Selector - VEI'), 		down = 3627, cockpit_device_id = 9, value_down = 0.1},
    {category = _('INS'), name = _('INS Mode Selector - CAL'), 		down = 3627, cockpit_device_id = 9, value_down = 0.2},
    {category = _('INS'), name = _('INS Mode Selector - TST'), 		down = 3627, cockpit_device_id = 9, value_down = 0.3},
    {category = _('INS'), name = _('INS Mode Selector - ALN'), 		down = 3627, cockpit_device_id = 9, value_down = 0.4},
    {category = _('INS'), name = _('INS Mode Selector - ALCM'),		down = 3627, cockpit_device_id = 9, value_down = 0.5},
    {category = _('INS'), name = _('INS Mode Selector - NAV'),		down = 3627, cockpit_device_id = 9, value_down = 0.6},
    {category = _('INS'), name = _('INS Mode Selector - SEC'),		down = 3627, cockpit_device_id = 9, value_down = 0.7},
	{category = _('INS'), name = _('INS Mode CCW'), 				down = device_commands.Helper_INSModeSelect_INC,  value_down=-1.0},
	{category = _('INS'), name = _('INS Mode CW'), 					down = device_commands.Helper_INSModeSelect_INC,  value_down=1.0 },
    {category = _('INS'), name = _('INS Operational Mode - N'),		down = 3629, cockpit_device_id = 9, value_down = 0.0},
    {category = _('INS'), name = _('INS Operational Mode - STS'),	down = 3629, cockpit_device_id = 9, value_down = 0.1},
    {category = _('INS'), name = _('INS Operational Mode - DCI'),	down = 3629, cockpit_device_id = 9, value_down = 0.2},
    {category = _('INS'), name = _('INS Operational Mode - CRV'),	down = 3629, cockpit_device_id = 9, value_down = 0.3},
    {category = _('INS'), name = _('INS Operational Mode - MAIN'),	down = 3629, cockpit_device_id = 9, value_down = 0.4},
	{category = _('INS'), name = _('INS PCN Operational Mode CCW'), down = device_commands.Helper_INSOperMode_INC, value_down=1.0},
	{category = _('INS'), name = _('INS PCN Operational Mode CW'),	down = device_commands.Helper_INSOperMode_INC, value_down=-1.0 },

	--TACAN & ILS
	{category = _('TACAN & ILS'), name = _('VOR/ILS Freq MHz Dec'),	down = iCommandPlane_ILS_MHz_Decrease,															},
	{category = _('TACAN & ILS'), name = _('VOR/ILS Freq MHz Inc'),	down = iCommandPlane_ILS_MHz_Increase,															},
	{category = _('TACAN & ILS'), name = _('VOR/ILS Freq kHz Dec'),	down = iCommandPlane_ILS_KHz_Decrease,															},
	{category = _('TACAN & ILS'), name = _('VOR/ILS Freq kHz Inc'),	down = iCommandPlane_ILS_KHz_Increase,															},
	{category = _('TACAN & ILS'), name = _('VOR/ILS OFF'),			down = device_commands.Button_617, cockpit_device_id = devices.VORILS, value_down = 0.0,		},
	{category = _('TACAN & ILS'), name = _('VOR/ILS ON'),			down = device_commands.Button_617, cockpit_device_id = devices.VORILS, value_down = 1.0,		},
	{category = _('TACAN & ILS'), name = _('VOR/ILS ON/OFF'),		down = iCommandPlane_ILS_Power,																	},
	{category = _('TACAN & ILS'), name = _('TACAN CH 1-'),			down = iCommandPlane_TACAN_Chanel_Ones_Decrease,												},
	{category = _('TACAN & ILS'), name = _('TACAN CH 1+'),			down = iCommandPlane_TACAN_Chanel_Ones_Increase,												},
	{category = _('TACAN & ILS'), name = _('TACAN CH 10-'),			down = iCommandPlane_TACAN_Chanel_Tens_Decrease,												},
	{category = _('TACAN & ILS'), name = _('TACAN CH 10+'),			down = iCommandPlane_TACAN_Chanel_Tens_Increase,												},
	{category = _('TACAN & ILS'), name = _('TACAN CH Decrease'), 	down = device_commands.Helper_TAC_CH_INC, value_down=-1.0, 										},
	{category = _('TACAN & ILS'), name = _('TACAN CH Increase'), 	down = device_commands.Helper_TAC_CH_INC, value_down=1.0,  										},
	{category = _('TACAN & ILS'), name = _('TACAN CH XY Switch'), 	down = iCommandPlane_TACAN_Chanel_XY_Mode, 														},
	{category = _('TACAN & ILS'), name = _('TACAN CH X'), 			down = device_commands.Button_624, cockpit_device_id = devices.TACAN, value_down = 0.0, 		},
	{category = _('TACAN & ILS'), name = _('TACAN CH Y'), 			down = device_commands.Button_624, cockpit_device_id = devices.TACAN, value_down = 1.0, 		},
	{category = _('TACAN & ILS'), name = _('TACAN Mode OFF'),  		down = iCommandPlane_TACAN_Mode_Off,  															},
	{category = _('TACAN & ILS'), name = _('TACAN Mode REC'),  		down = iCommandPlane_TACAN_Mode_Rec,  															},
	{category = _('TACAN & ILS'), name = _('TACAN Mode TR'),   		down = iCommandPlane_TACAN_Mode_TR,   															},
	{category = _('TACAN & ILS'), name = _('TACAN Mode AA'),   		down = iCommandPlane_TACAN_Mode_AATR, 															},
	{category = _('TACAN & ILS'), name = _('TACAN Mode Next'), 		down = device_commands.Helper_TAC_MODE_INC, value_down=1.0,  									},
	{category = _('TACAN & ILS'), name = _('TACAN Mode Prev'), 		down = device_commands.Helper_TAC_MODE_INC, value_down=-1.0, 									},
	{category = _('TACAN & ILS'), name = _('TACAN Mode Cycle'), 	down = device_commands.Helper_TAC_MODE_Cycle,  													},

	--Volumes
	{category = _('Volumes'), name = _('VOR/ILS Volume Dec'), 			down = device_commands.Helper_VOL_VORILS_INC, value_down=-0.5,	},
	{category = _('Volumes'), name = _('VOR/ILS Volume Inc'), 			down = device_commands.Helper_VOL_VORILS_INC, value_down=0.5,	},
	{category = _('Volumes'), name = _('TACAN Volume Dec'), 			down = device_commands.Helper_VOL_TACAN_INC, value_down=-0.5, 	},
	{category = _('Volumes'), name = _('TACAN Volume Inc'), 			down = device_commands.Helper_VOL_TACAN_INC, value_down=0.5, 	},
	{category = _('Volumes'), name = _('MISSILE Volume Dec'),			down = device_commands.Helper_VOL_MISSILE_INC, value_down=-0.5,	},
	{category = _('Volumes'), name = _('MISSILE Volume Inc'), 			down = device_commands.Helper_VOL_MISSILE_INC, value_down=0.5,	},
	{category = _('Volumes'), name = _('INTERCOM/APPROACH Volume Dec'),	down = device_commands.Helper_VOL_TBAPP_INC, value_down=-0.5,	},
	{category = _('Volumes'), name = _('INTERCOM/APPROACH Volume Inc'),	down = device_commands.Helper_VOL_TBAPP_INC, value_down=0.5, 	},
	{category = _('Volumes'), name = _('TP/MARKER Volume Dec'),		 	down = device_commands.Helper_VOL_TPMKR_INC, value_down=-0.5,	},
	{category = _('Volumes'), name = _('TP/MARKER Volume Inc'),			down = device_commands.Helper_VOL_TPMKR_INC, value_down=0.5,	},
	{category = _('Volumes'), name = _('UHF RED Volume Dec'), 			down = device_commands.Helper_VOL_UHF_INC, value_down=-0.5, 	},
	{category = _('Volumes'), name = _('UHF RED Volume Inc'),			down = device_commands.Helper_VOL_UHF_INC, value_down=0.5,		},
	{category = _('Volumes'), name = _('V/UHF GREEN Volume Dec'),		down = device_commands.Helper_VOL_VUHF_INC, value_down=-0.5,	},
	{category = _('Volumes'), name = _('V/UHF GREEN Volume Inc'),		down = device_commands.Helper_VOL_VUHF_INC, value_down=0.5,		},	
	
	
	-- Pilot & Seat Controls    
	{category = _('Pilot & Seat Controls'), name = _('NVG Toggle'),						down = iCommandViewNightVisionGogglesOn,											},
	{category = _('Pilot & Seat Controls'), name = _('Stow/Unstow NVG'),				down = iCommandPlaneDLK_Target3,													},
	{category = _('Pilot & Seat Controls'), name = _('Sun Visor Toggle'),				down = iCommandPlaneDLK_Target2,													},
	{category = _('Pilot & Seat Controls'), name = _('Toggle Mount NVG on helmet'),		down = iCommandPlaneDLK_Target1,													},
	{category = _('Pilot & Seat Controls'), name = _('Pilot Body TOGGLE'),				down = iCommandCockpitShowPilotOnOff,												},
	{category = _('Pilot & Seat Controls'), name = _('Mirrors TOGGLE'),					down = iCommandToggleMirrors,														},
	{category = _('Pilot & Seat Controls'), name = _('Eject (3 times)'),				down = iCommandPlaneEject,															},	
	{category = _('Pilot & Seat Controls'), name = _('Seat RAISE'),						pressed = iCommandPilotSeatAdjustmentUp, up = iCommandPilotSeatAdjustmentStop,		},
	{category = _('Pilot & Seat Controls'), name = _('Seat LOWER'),						pressed = iCommandPilotSeatAdjustmentDown, up = iCommandPilotSeatAdjustmentStop,	},
	{category = _('Pilot & Seat Controls'),	name = _('Flight Clock START/STOP/RESET'), 	down = iCommandFlightClockReset, 													},
	{category = _('Pilot & Seat Controls'), name = _('Timer START/STOP/RESET'),			down = iCommandClockElapsedTimeReset, 												},
	{category = _('Pilot & Seat Controls'), name = _('Eject'),							pressed = iCommandPlaneEject 														},	
	{category = _('Pilot & Seat Controls'), name = _('Hide/Show Control Stick'),		down = iCommandPlaneCircuitBreaker_10 												},
	{category = _('Pilot & Seat Controls'), name = _('Hide/Show Throttle'),				down = iCommandPlaneCircuitBreaker_11 												},
	{category = _('Pilot & Seat Controls'), name = _('NVG Gain Increase'), 				pressed = iCommandPlane_Helmet_Brightess_Up 										},	
	{category = _('Pilot & Seat Controls'), name = _('NVG Gain Decrease'), 				pressed = iCommandPlane_Helmet_Brightess_Down 										},	
	
	-- Weapon/CMDS Adjustment
	{category = {_('Ground Adjustment')}, name = _('Change Matra Type 155 Burst Mode (1/3/6/18)'),	},
	{category = {_('Ground Adjustment')}, name = _('Change Laser Code, Hundreds (1..8)'),		    },
	{category = {_('Ground Adjustment')}, name = _('Change Laser Code, Tens (1..8)'),			    },
	{category = {_('Ground Adjustment')}, name = _('Change Laser Code, Ones (1..8)'),			    },
	{category = {_('Ground Adjustment')}, name = _('Change Gun Burst Lenght (0.5 or 1.0)'),	        },

	-- Communications
	{category = _('Communications'), name = _('Request AWACS Available Tanker'), },
	{category = _('Communications'), name = _('Receive Mode'), 					 },

	-- Cheat
	{category = _('Cheat'), name = _('Start Procedure'), down = iCommandEnginesStart, },
    {category = _('Cheat'), name = _('Stop Procedure'),  down = iCommandEnginesStop,  },
	
	--DEBUG
	{category = _('Debug'), name = _('DEBUG POS Increase'),		down = iCommandPlane_ABRIS_Axis_Increase },
	{category = _('Debug'), name = _('DEBUG POS Decrease'),		down = iCommandPlane_ABRIS_Axis_Decrease },
	{category = _('Debug'), name = _('RDI RADAR Drop Lock'),	down = iCommandPlane_ADF_Test			 },
}) 

join(res.axisCommands,{
	{combos = defaultDeviceAssignmentFor("roll")  ,  action = iCommandPlaneRoll		   , name = _('Roll')	},
	{combos = defaultDeviceAssignmentFor("pitch") ,  action = iCommandPlanePitch	   , name = _('Pitch')	},
	{combos = defaultDeviceAssignmentFor("rudder"),  action = iCommandPlaneRudder	   , name = _('Rudder')	},
	{combos = defaultDeviceAssignmentFor("thrust"),  action = iCommandPlaneThrustCommon, name = _('Thrust')	},
	{action = iCommandPlaneSelecterHorizontalAbs, 	name = _('TDC Slew Horizontal')},
	{action = iCommandPlaneSelecterVerticalAbs	, 	name = _('TDC Slew Vertical')},
	{action = iCommandPlaneRadarVerticalAbs	, 		name = _('Radar Antenna Elevation')},
	{action = iCommandWheelBrake,					name = _('Wheel Brakes')},
	{action = iCommandLeftWheelBrake,				name = _('Wheel Brake Left')},
	{action = iCommandRightWheelBrake,				name = _('Wheel Brake Right')},
	{action = device_commands.Button_915, cockpit_device_id = devices.ENGPANEL, 	name = _('Emergency Throttle')},
	{action = device_commands.Button_701, cockpit_device_id = devices.SYSLIGHTS,	name = _('VOR/ILS Volume')},
	{action = device_commands.Button_702, cockpit_device_id = devices.SYSLIGHTS,	name = _('TACAN Volume')},
	{action = device_commands.Button_703, cockpit_device_id = devices.SYSLIGHTS,	name = _('MISSILE Volume')},
	{action = device_commands.Button_704, cockpit_device_id = devices.SYSLIGHTS,	name = _('INTERCOM/APPROACH Volume')},
	{action = device_commands.Button_705, cockpit_device_id = devices.SYSLIGHTS,	name = _('TP/MARKER Volume')},
	{action = device_commands.Button_706, cockpit_device_id = devices.SYSLIGHTS,	name = _('UHF RED Volume')},
	{action = device_commands.Button_707, cockpit_device_id = devices.SYSLIGHTS,	name = _('V/UHF Radio Volume')},
	{action = device_commands.Button_309, cockpit_device_id = devices.FLIGHTINST,	name = _('Altimeter Calibration')},
	{action = device_commands.Button_328, cockpit_device_id = devices.FLIGHTINST,	name = _('Backup ADI Pitch Adjust')},
	{action = device_commands.Button_488, cockpit_device_id = devices.RADAR, 		name = _('Radar Gain Dial')},
	{action = device_commands.Button_209, cockpit_device_id = devices.VTH_VTB, 		name = _('Target Wingspan Knob')},
	{action = device_commands.Button_228, cockpit_device_id = devices.SYSLIGHTS,	name = _('RWR Light Brightnes Control')},
	{action = device_commands.Button_202, cockpit_device_id = devices.VTH_VTB,  	name = _('HUD Brightness')},
	{action = device_commands.Button_639, cockpit_device_id = devices.SYSLIGHTS,	name = _('Dashboard U.V. Lights Knob')},
	{action = device_commands.Button_640, cockpit_device_id = devices.SYSLIGHTS,	name = _('Dashboard Panel Lights Knob')},
	{action = device_commands.Button_641, cockpit_device_id = devices.SYSLIGHTS,	name = _('Red Flood Lights Knob')},
	{action = device_commands.Button_642, cockpit_device_id = devices.SYSLIGHTS,	name = _('Console Panel Lights Knob')},
	{action = device_commands.Button_643, cockpit_device_id = devices.SYSLIGHTS,	name = _('Caution/Advisory Lights Knob')},
	{action = device_commands.Button_644, cockpit_device_id = devices.SYSLIGHTS,	name = _('White Flood Lights Knob')},
	{action = device_commands.Button_575, cockpit_device_id = devices.SYSLIGHTS,	name = _('Light Brightnes Control/Test')},
	{action = device_commands.Button_920, cockpit_device_id = devices.SYSLIGHTS,	name = _('Refuel Lights Brightness Knob')},


}) return res
